import cv2
import numpy as np
from playsound import playsound
import time

# Fonction pour jouer un son
def jouer_son(fichier_son):
    playsound(fichier_son)

# Fonction de recherche d'image
def chercher_image(image_source, image_cible, seuil=0.8):
    img = cv2.imread(image_source)
    template = cv2.imread(image_cible)
    res = cv2.matchTemplate(img, template, cv2.TM_CCOEFF_NORMED)
    loc = np.where(res >= seuil)
    return list(zip(*loc[::-1]))

# Boucle principale
while True:
    # Capture d'écran (à adapter selon ton environnement Android)
    # Exemple : tu peux utiliser une image fixe pour tester
    source = "screenshot.png"

    images_a_chercher = [
        ("exchange1.png", "merc.wav"),
        ("exchange2.png", "merc.wav"),
        ("exchange3.png", "merc.wav"),
        ("exchange4.png", "merc.wav"),
        ("gold-dm1.png", "gold.wav"),
        ("gold-dm2.png", "gold.wav")
    ]

    for img, son in images_a_chercher:
        positions = chercher_image(source, img)
        if positions:
            jouer_son(son)
            for pos in positions:
                print(f"Image {img} trouvée à : {pos}")

    time.sleep(0.5)